jQuery(document).ready(function($){


    $('table table tr').each(function() {
        // Check if the second column is empty
        if ($(this).find('td:eq(1)').text().trim() === '') {
            // Add the class 'text-bold' to the first column
            $(this).find('td:eq(0)').addClass('text-danger');
        }
    });

    var contactData = $('[name="existing_cid"]').val();
    if (contactData) {
        var contact = JSON.parse(contactData);
        if (contact) {
            var excludedFields = ['first_name', 'last_name', 'website', 'user_id', 'phones', 'emails'];
            $.each(contact, function(key, value) {
                if ($.inArray(key, excludedFields) === -1) {
                    var field = $('[name="' + key + '"]');
                    if (field.length) {
                        field.val(value).trigger('change');
                    }
                }
            });
        }
    }

    $('form').find('[required]').each(function() {
        var wrapper = $(this).closest('[data-field-wrapper]');
        if (wrapper) {
            var label = wrapper.find('label');
            if (label.length && !label.find('.required-star').length) {
                label.append(' <span class="required-star" style="color: red;">*</span>');
            }
        }
    });

    $('form').on('submit', function(event) {
        var firstInvalidField = null;
        var firstInvalidTabId = null;

        // Check all required fields
        $(this).find('[required]').each(function() {
            if (!$(this).val()) {
                if (!firstInvalidField) {
                    firstInvalidField = $(this);
                    firstInvalidTabId = $(this).closest('.tab-pane').attr('id');
                }

                // Highlight the field and show a message
                $(this).css('border-color', 'red');
                if (true) {
                    $('<span class="text-danger">Αυτό το πεδίο είναι υποχρεωτικό</span>').insertAfter($(this)).fadeOut(6000);
                }
                
            } else {
                $(this).css('border-color', '');
                $(this).next('.text-danger').remove();
            }
        });

        if (firstInvalidField) {
            event.preventDefault();

            // Switch to the tab of the first invalid field
            if (firstInvalidTabId) {
                // Find the tab link
                const tabLink = $('a[href="#' + firstInvalidTabId + '"]');
                tabLink.tab('show');

                // Wait for the tab to be fully active before focusing the field
                tabLink.on('shown.bs.tab', function() {
                    setTimeout(function() {
                        // Scroll to the first invalid field
                        $('html, body').animate({
                            scrollTop: firstInvalidField.offset().top - 100
                        }, 500);

                        firstInvalidField.focus();

                    }, 400);
                });
            }
        }

        setTimeout(function (){
            $("button[type='submit']").removeAttr("disabled");
        },1000);
    });


    $(document).on('click','.read-more', function(event) {
        event.preventDefault();
        var fullText = $(this).closest('.readmore-wrapper').find('.full-text').text();


        console.log($(this).closest('.readmore-wrapper').find('.full-text').text());

        swal({
            title: '',
            text: fullText,
            icon: "info",

        });
    });


    // When country changes
    $(document).on("change",'.country_id_wrapper',function(){
        if($(this).closest('.repeatable-element').length){
            var c = $(this).closest('.repeatable-element');
        }else{
            var c = $(this).closest('.row');
        }

        var countryId = $(this).val();
        c.find('.division_id_wrapper ').attr('disabled', 'disabled');
        c.find('.city_id_wrapper ').attr('disabled', 'disabled');

        $.ajax({
            url: app_url+'/api/divisions/' + countryId,
            method: 'GET',
            success: function(data) {
                var divisions = c.find('.division_id_wrapper');
                divisions.empty();
                divisions.append('<option value="">-</option>');
                $.each(data, function(key, value) {
                    divisions.append('<option value="'+ value.id +'">'+ value.name +'</option>');
                });
                divisions.removeAttr('disabled');
            }
        });
    });

    // When division changes
    $(document).on("change",'.division_id_wrapper',function(){
        if($(this).closest('.repeatable-element').length){
            var c = $(this).closest('.repeatable-element');
        }else{
            var c = $(this).closest('.row');
        }
        var divisionId = $(this).val();
        c.find('.city_id_wrapper').attr('disabled', 'disabled');

        $.ajax({
            url: app_url+'/api/cities/' + divisionId,
            method: 'GET',
            success: function(data) {
                var cities = c.find('.city_id_wrapper');
                cities.empty();
                cities.append('<option value="">-</option>');
                $.each(data, function(key, value) {
                    cities.append('<option value="'+ value.id +'">'+ value.name +'</option>');
                });
                cities.removeAttr('disabled');
            }
        });
    });



    $(".move-element-down,.move-element-up").remove();

    //assuming the country is already populated we go for division and city
    handleLocationFields();




    $(document).on("click", "#checkAADE", function() {
        var afm = $("input[name='afm']").val();
        $.post($(this).data('url'), {
            afm: afm
        }, function(response) {
            response = JSON.parse(response);

            console.log(response);

            // Check if the response contains a valid AFM
            if (response.afm !== '' && response.stopDate=='') {
                $("[name='tax_office']").val(response.doy).trigger("change");
                $("[name='company']").val(response.onomasia);
                $("[name='epaggelma']").val(response.firmFlagDescr);
                $("[name='city']").val(response.postalAreaDescr);
                $("[name='tk']").val(response.postalZipCode);
                $("[name='country']").val("GR");
                $("[name='address']").val(response.postalAddress + " " + response.postalAddressNo);
            } else {
                // Show an error message if AFM is empty or invalid
                swal("Το ΑΦΜ δεν υπάρχει ή δεν είναι επαγγελματικό.");
            }
        });
    });



    $(document).on("change",'select[data-endpoint]',function(){
        if($(this).closest('.repeatable-element').length){
            var c = $(this).closest('.repeatable-element');
        }else{
            var c = $(this).closest('.row');
        }
        var to_populate = c.find('.'+$(this).data('populate'));
        var endpoint = $(this).data('endpoint');
        var oid = $(this).val();
        to_populate.attr('disabled', 'disabled');


        $.ajax({
            url: app_url+ endpoint + '/'+ oid,
            method: 'GET',
            success: function(data) {

                to_populate.empty();
                to_populate.append('<option value="">-</option>');
                $.each(data, function(key, value) {
                    to_populate.append('<option value="'+ value.id +'">'+ value.name +'</option>');
                });
                to_populate.removeAttr('disabled');
            }
        });
    });


    handleApiFields();


    setTimeout(function (){
        $("[data-toggle='tooltip']").each(function (){
            $(this).tooltip();
        });

        $("[data-toggle='popover']").each(function (){
            $(this).popover({
                html: true
            });
        });
    },1500);
});


function handleApiFields(){
    setTimeout(function (){
        $('select[data-endpoint]').each(function (i){
            if($(this).closest('.repeatable-element').length){

                var box = $(this).closest('.repeatable-element').find("."+$(this).data('populate'));

                var c = $(this).closest('.container-repeatable-elements').parent().find("input[type='hidden']");
                var data =  JSON.parse(c.val());
                var endpoint = $(this).data('endpoint');
                var oid = data[i][$(this).data('named')];
                var el_selected = data[i][$(this).data('selects')]

                $.ajax({
                    url: app_url+ endpoint + '/'+ oid,
                    method: 'GET',
                    success: function(data) {

                        box.empty();
                        box.append('<option value="">-</option>');
                        $.each(data, function(key, value) {
                            box.append('<option value="'+ value.id +'">'+ value.name +'</option>');
                        });
                        box.removeAttr('disabled');
                        box.val(el_selected).trigger("change");
                    }
                });
            }
        });
    },1000);
}

function handleLocationFields(){
    setTimeout(function (){
        $(".division_id_wrapper").each(function (i){
            if($(this).closest('.repeatable-element').length){

                var box = $(this);

                var c = $(this).closest('.container-repeatable-elements').parent().find("input[type='hidden']");
                var data =  JSON.parse(c.val());

                var countryId = data[i].country;
                var division_selected = data[i].division;
                $.ajax({
                    url: app_url+'/api/divisions/' + countryId,
                    method: 'GET',
                    success: function(data) {
                        var divisions = box;
                        divisions.empty();
                        divisions.append('<option value="">-</option>');
                        $.each(data, function(key, value) {
                            divisions.append('<option value="'+ value.id +'">'+ value.name +'</option>');
                        });
                        divisions.removeAttr('disabled');
                        divisions.val(division_selected).trigger("change");
                    }
                });
            }
        });
        setTimeout(function (){
            $(".city_id_wrapper").each(function (i){
                if($(this).closest('.repeatable-element').length){

                    var box = $(this);

                    var c = $(this).closest('.container-repeatable-elements').parent().find("input[type='hidden']");
                    var data =  JSON.parse(c.val());

                    var countryId = data[i].country;
                    var division_selected = data[i].division;
                    var city_selected = data[i].city;


                    box.val(city_selected).trigger("change");
                }
            });
        },1000);
    },1000);
}
