<?php

use App\Models\Contract;
use App\Models\User;
use App\Notifications\ContactRequest;
use App\Notifications\RenewRequest;
use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {

    return view('welcome');
});


Route::get("/fix",function (){
    $manuals = \App\Models\Checklist::all();

    foreach ($manuals as $manual){
        $manual->extras = $manual->extras;
        $manual->save();
    }

    dd('done');
});

Route::get('/mails',function (){
    $client =\Webklex\IMAP\Facades\Client::account('default');
    $client->connect();

    $folder = $client->getFolder('INBOX');

    $recentMessages = $folder
        ->query()
        ->since(\Carbon\Carbon::now()->subWeeks(1))
        ->get();

//    $this->info(sprintf('There are %d messages from the last 1 weeks in %s', $recentMessages->count(), 'INBOX'));

    foreach ($recentMessages as $message) {
        $inboundEmail = \BeyondCode\Mailbox\InboundEmail::fromMessage($message->getHeader()->raw . $message->getRawBody());
        if (!\BeyondCode\Mailbox\InboundEmail::where('message_id', $inboundEmail->message()->getHeaderValue('Message-Id'))->exists()) {
            //$inboundEmail->save();
            \BeyondCode\Mailbox\Facades\Mailbox::callMailboxes($inboundEmail);
        }
    }
});


Route::get('/seed',function (){
    Artisan::call('iseed statics --force');
    Artisan::call('iseed manuals --force');
    Artisan::call('iseed checklists --force');
    return back();
});

