@extends(backpack_view('blank'))

@php
    $defaultBreadcrumbs = [
      trans('backpack::crud.admin') => url(config('backpack.base.route_prefix'), 'dashboard'),
      $crud->entity_name_plural => url($crud->route),
      trans('backpack::crud.preview') => false,
    ];

    // if breadcrumbs aren't defined in the CrudController, use the default breadcrumbs
    $breadcrumbs = $breadcrumbs ?? $defaultBreadcrumbs;
@endphp

@section('header')
    <section class="container-fluid d-print-none">
        <a href="javascript: window.print();" class="btn float-right"><i class="la la-print"></i></a>
        <h2>
            <span class="text-capitalize">{!! $crud->getHeading() ?? $crud->entity_name_plural !!}</span>
            <small>{!! $crud->getSubheading() ?? mb_ucfirst(trans('backpack::crud.preview')).' '.$crud->entity_name !!}.</small>
            @if ($crud->hasAccess('list'))
                <small class=""><a href="{{ url($crud->route) }}" class="font-sm"><i class="la la-angle-double-left"></i> {{ trans('backpack::crud.back_to_all') }} <span>{{ $crud->entity_name_plural }}</span></a></small>
            @endif
        </h2>
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="{{ $crud->getShowContentClass() }}">

            <!-- Default box -->
            <div class="">
                @if ($crud->model->translationEnabled())
                    <div class="row">
                        <div class="col-md-12 mb-2">
                            <!-- Change translation button group -->
                            <div class="btn-group float-right">
                                <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    {{trans('backpack::crud.language')}}: {{ $crud->model->getAvailableLocales()[request()->input('locale')?request()->input('locale'):App::getLocale()] }} &nbsp; <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    @foreach ($crud->model->getAvailableLocales() as $key => $locale)
                                        <a class="dropdown-item" href="{{ url($crud->route.'/'.$entry->getKey().'/show') }}?locale={{ $key }}">{{ $locale }}</a>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif

                @if (isset($crud->tabs) && count($crud->tabs) > 0)
                    {{-- Tabs navigation --}}
                    <ul class="nav nav-tabs" role="tablist">
                        @foreach ($crud->tabs as $tab)
                            <li role="presentation" class="nav-item">
                                <a href="#{{ \Illuminate\Support\Str::slug($tab) }}" aria-controls="{{ \Illuminate\Support\Str::slug($tab) }}" role="tab" data-toggle="tab" class="nav-link {{ $loop->first ? 'active' : '' }}">
                                    {{ $tab }}
                                </a>
                            </li>
                        @endforeach
                    </ul>

                    {{-- Tab panes --}}
                    <div class="tab-content mt-3">
                        @foreach ($crud->tabs as $tab)
                            <div role="tabpanel" class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" id="{{ \Illuminate\Support\Str::slug($tab) }}">
                                <div class="card no-padding no-border">
                                    <table class="table table-striped mb-0">
                                        <tbody>
                                        @foreach ($crud->columns() as $column)
                                            @if (isset($column['tab']) && $column['tab'] == $tab)
                                                <tr>
                                                    <td>
                                                        <strong>{!! $column['label'] !!}:</strong>
                                                    </td>
                                                    <td>
                                                        @if (!isset($column['type']))
                                                            @include('crud::columns.text')
                                                        @else
                                                            @if(view()->exists('vendor.backpack.crud.columns.'.$column['type']))
                                                                @include('vendor.backpack.crud.columns.'.$column['type'])
                                                            @elseif(view()->exists('crud::columns.'.$column['type']))
                                                                @include('crud::columns.'.$column['type'])
                                                            @else
                                                                @include('crud::columns.text')
                                                            @endif
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach

                                        @if ($crud->buttons()->where('stack', 'line')->count())
                                            <tr>
                                                <td><strong>{{ trans('backpack::crud.actions') }}</strong></td>
                                                <td>



                                                    <div class="d-flex justify-content-between">

                                                            @foreach ($crud->columns() as $column)
                                                                @if($column['type']=='flow')
                                                                    @php $flow = true @endphp
                                                                @endif
                                                            @endforeach

                                                            @if(isset($flow))
                                                                <button type="button" class="btn btn-success" onclick="jQuery('.flow-btn').trigger('click')">{{__("backpack::crud.save")}}</button>
                                                            @endif
                                                        <div>
                                                            @include('crud::inc.button_stack', ['stack' => 'line'])
                                                        </div>

                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    {{-- No tabs defined, display content normally --}}
                    <div class="card no-padding no-border">
                        <table class="table table-striped mb-0">
                            <tbody>
                            @foreach ($crud->columns() as $column)
                                <tr>
                                    <td>
                                        <strong>{!! $column['label'] !!}:</strong>
                                    </td>
                                    <td>
                                        @if (!isset($column['type']))
                                            @include('crud::columns.text')
                                        @else
                                            @if(view()->exists('vendor.backpack.crud.columns.'.$column['type']))
                                                @include('vendor.backpack.crud.columns.'.$column['type'])
                                            @elseif(view()->exists('crud::columns.'.$column['type']))
                                                @include('crud::columns.'.$column['type'])
                                            @else
                                                @include('crud::columns.text')
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @endforeach

                            @if ($crud->buttons()->where('stack', 'line')->count())
                                <tr>
                                    <td><strong>{{ trans('backpack::crud.actions') }}</strong></td>
                                    <td>
                                        @include('crud::inc.button_stack', ['stack' => 'line'])
                                        @foreach ($crud->columns() as $column)
                                            @if($column['type']=='flow')
                                                @php $flow = true @endphp
                                            @endif
                                        @endforeach

                                        @if(isset($flow))
                                            <button type="button" class="btn btn-success" onclick="jQuery('.flow-btn').trigger('click')">{{__("backpack::crud.save")}}</button>
                                        @endif
                                    </td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div>
                @endif

            </div><!-- /.box -->

        </div>
    </div>
@endsection

@section('after_styles')
    <link rel="stylesheet" href="{{ asset('packages/backpack/crud/css/crud.css').'?v='.config('backpack.base.cachebusting_string') }}">
    <link rel="stylesheet" href="{{ asset('packages/backpack/crud/css/show.css').'?v='.config('backpack.base.cachebusting_string') }}">
    <style>
        .nav-tabs-custom {
            box-shadow: none;
        }
        .nav-tabs-custom > .nav-tabs.nav-stacked > li {
            margin-right: 0;
        }

        .tab-pane .form-group h1:first-child,
        .tab-pane .form-group h2:first-child,
        .tab-pane .form-group h3:first-child {
            margin-top: 0;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('packages/backpack/crud/css/form.css').'?v='.config('backpack.base.cachebusting_string') }}">
    <link rel="stylesheet" href="{{ asset('packages/backpack/crud/css/edit.css').'?v='.config('backpack.base.cachebusting_string') }}">
@endsection

@section('after_scripts')
    <script src="{{ asset('packages/backpack/crud/js/crud.js').'?v='.config('backpack.base.cachebusting_string') }}"></script>
    <script src="{{ asset('packages/backpack/crud/js/show.js').'?v='.config('backpack.base.cachebusting_string') }}"></script>
@endsection
