<!-- text input -->
@include('crud::fields.inc.wrapper_start')
    <label>{!! $field['label'] !!}</label>

    @if(isset($field['prefix']) || isset($field['suffix'])) <div class="input-group"> @endif
        @if(isset($field['prefix'])) <div class="input-group-prepend"><span class="input-group-text">{!! $field['prefix'] !!}</span></div> @endif
        <input
            type="text"
            name="{{ $field['name'] }}"
            id="id_{{$field['name']}}"
            value="{{ old(square_brackets_to_dots($field['name'])) ?? $field['value'] ?? $field['default'] ?? '' }}"
            @include('crud::fields.inc.attributes')
        >
        @if(isset($field['suffix'])) <div class="input-group-append"><span class="input-group-text">{!! $field['suffix'] !!}</span></div> @endif
    @if(isset($field['prefix']) || isset($field['suffix'])) </div> @endif

    {{-- HINT --}}
    @if (isset($field['hint']))
        <p id="hint_{{$field['name']}}" class="help-block">{!! $field['hint'] !!}</p>
    @endif
@include('crud::fields.inc.wrapper_end')

@if(isset($field['unique']))
    @push('crud_fields_scripts')
        <script>
            jQuery(document).ready(function ($){
                $(document).on("keyup change input","#id_{{$field['name']}}",function (){
                    $.post("{{backpack_url('checkunique')}}",{
                        value: $(this).val(),
                        current: "{{ old(square_brackets_to_dots($field['name'])) ?? $field['value'] ?? $field['default'] ?? '' }}",
                        col: "{{$field['unique']['col']}}",
                        table: "{{$field['unique']['table']}}"
                    },function (response){
                        if(response!=="OK"){
                            $("#hint_{{$field['name']}}").html("<b class='text-danger'>Field IS NOT UNIQUE!</b>");
                            $("#saveActions").hide();
                        }else{
                            $("#hint_{{$field['name']}}").html("{!! $field['hint'] !!}");
                            $("#saveActions").show();
                        }
                    });
                });
            });
        </script>
    @endpush
@endif

{{-- FIELD EXTRA CSS  --}}
{{-- push things in the after_styles section --}}

    {{-- @push('crud_fields_styles')
        <!-- no styles -->
    @endpush --}}


{{-- FIELD EXTRA JS --}}
{{-- push things in the after_scripts section --}}

    {{-- @push('crud_fields_scripts')
        <!-- no scripts -->
    @endpush --}}


{{-- Note: you can use @if ($crud->checkIfFieldIsFirstOfItsType($field, $fields)) to only load some CSS/JS once, even though there are multiple instances of it --}}
