<!-- select2 from ajax multiple -->
@php
    $connected_entity = new $field['model'];
    $connected_entity_key_name = $connected_entity->getKeyName();
    $old_value = old(square_brackets_to_dots($field['name'])) ?? $field['value'] ?? $field['default'] ?? false;

    // by default set ajax query delay to 500ms
    $field['delay'] = $field['delay'] ?? 500;
@endphp

@include('crud::fields.inc.wrapper_start')
<label>{!! $field['label'] !!}</label>
@include('crud::fields.inc.translatable_icon')
<select
    name="{{ $field['name'] }}[]"
    style="width: 100%"
    data-init-function="bpFieldInitSelect2FromAjaxMultipleElement"
    data-field-is-inline="{{ var_export($inlineCreate ?? false) }}"
    data-dependencies="{{ isset($field['dependencies']) ? json_encode(Arr::wrap($field['dependencies'])) : json_encode([]) }}"
    data-placeholder="{{ $field['placeholder'] }}"
    data-minimum-input-length="{{ $field['minimum_input_length'] }}"
    data-data-source="{{ $field['data_source'] }}"
    data-method="{{ $field['method'] ?? 'GET' }}"
    data-field-attribute="{{ $field['attribute'] }}"
    data-connected-entity-key-name="{{ $connected_entity_key_name }}"
    data-include-all-form-fields="{{ isset($field['include_all_form_fields']) ? ($field['include_all_form_fields'] ? 'true' : 'false') : 'false' }}"
    data-ajax-delay="{{ $field['delay'] }}"
    data-language="{{ str_replace('_', '-', app()->getLocale()) }}"
    @include('crud::fields.inc.attributes', ['default_class' =>  'form-control'])
    multiple>

    @if ($old_value)
        @foreach ($old_value as $item)
            @if (!is_object($item))
                @php
                    $item = $connected_entity->find($item);
                @endphp
            @endif

            <option value="{{ $item->getKey() }}" selected @if(isset($entry) && !is_null($item->pivot) && $item->pivot->is_main == 1) data-main="true" @endif>
                {{ $item->{$field['attribute']} }}
            </option>
        @endforeach
    @endif
</select>

@if (isset($field['hint']))
    <p class="help-block">{!! $field['hint'] !!}</p>
@endif
@include('crud::fields.inc.wrapper_end')


{{-- ########################################## --}}
{{-- Extra CSS and JS for this particular field --}}
{{-- If a field type is shown multiple times on a form, the CSS and JS will only be loaded once --}}
@if ($crud->fieldTypeNotLoaded($field))
    @php
        $crud->markFieldTypeAsLoaded($field);
    @endphp

    {{-- FIELD CSS - will be loaded in the after_styles section --}}
    @push('crud_fields_styles')
        <!-- include select2 css-->
        <link href="{{ asset('packages/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css"/>
        <link href="{{ asset('packages/select2-bootstrap-theme/dist/select2-bootstrap.min.css') }}" rel="stylesheet"
              type="text/css"/>
    @endpush

    {{-- FIELD JS - will be loaded in the after_scripts section --}}
    @push('crud_fields_scripts')
        <!-- include select2 js-->
        <script src="{{ asset('packages/select2/dist/js/select2.full.min.js') }}"></script>
        @if (app()->getLocale() !== 'en')
            <script
                src="{{ asset('packages/select2/dist/js/i18n/' . str_replace('_', '-', app()->getLocale()) . '.js') }}"></script>
        @endif
    @endpush

@endif

<!-- include field specific select2 js-->
@push('crud_fields_scripts')
    <script>
        function formatOption(option) {
            if (!option.id) {
                return option.text;
            }
            var $option = $('<span>' + option.text + '</span>');
            return $option;
        }

        function formatSelection(option) {
            if (!option.id) {
                return option.text;
            }

            // Check if the option has data-main="true"
            var isChecked = $(option.element).data('main') === true;

            // Update the hidden input value if checked
            if (isChecked) {
                $('#mainOption').val(option.id);
            }

            var $selection = $(
                '<span>' + option.text +
                ' <input type="radio" name="is_main" value="' + option.id + '"' +
                (isChecked ? ' checked' : '') + ' onclick="setMainOption(this)"></span>'
            );
            return $selection;
        }

        function setMainOption(radio) {
            $('#mainOption').val(radio.value);
        }

        function bpFieldInitSelect2FromAjaxMultipleElement(element) {
            var form = element.closest('form');
            var $placeholder = element.attr('data-placeholder');
            var $minimumInputLength = element.attr('data-minimum-input-length');
            var $dataSource = element.attr('data-data-source');
            var $method = element.attr('data-method');
            var $fieldAttribute = element.attr('data-field-attribute');
            var $connectedEntityKeyName = element.attr('data-connected-entity-key-name');
            var $includeAllFormFields = element.attr('data-include-all-form-fields') == 'false' ? false : true;
            var $allowClear = element.attr('data-column-nullable') == 'true' ? true : false;
            var $dependencies = JSON.parse(element.attr('data-dependencies'));
            var $ajaxDelay = element.attr('data-ajax-delay');
            var $selectedOptions = typeof element.attr('data-selected-options') === 'string' ? JSON.parse(element.attr('data-selected-options')) : JSON.parse("[]");
            var $isFieldInline = element.data('field-is-inline');

            var select2AjaxMultipleFetchSelectedEntries = function (element) {
                return new Promise(function (resolve, reject) {
                    $.ajax({
                        url: $dataSource,
                        data: {
                            'keys': $selectedOptions
                        },
                        type: $method,
                        success: function (result) {
                            resolve(result);
                        },
                        error: function (result) {
                            reject(result);
                        }
                    });
                });
            };

            if (!$(element).hasClass("select2-hidden-accessible")) {
                $(element).select2({
                    theme: 'bootstrap',
                    multiple: true,
                    placeholder: $placeholder,
                    minimumInputLength: $minimumInputLength,
                    dropdownParent: $isFieldInline ? $('#inline-create-dialog .modal-content') : document.body,
                    templateResult: formatOption,
                    templateSelection: formatSelection,
                    ajax: {
                        url: $dataSource,
                        type: $method,
                        dataType: 'json',
                        delay: $ajaxDelay,
                        data: function (params) {
                            if ($includeAllFormFields) {
                                return {
                                    q: params.term, // search term
                                    page: params.page, // pagination
                                    form: form.serializeArray() // all other form inputs
                                };
                            } else {
                                return {
                                    q: params.term, // search term
                                    page: params.page, // pagination
                                };
                            }
                        },
                        processResults: function (data, params) {
                            params.page = params.page || 1;

                            return {
                                results: $.map(data.data, function (item) {
                                    return {
                                        text: item[$fieldAttribute],
                                        id: item[$connectedEntityKeyName]
                                    }
                                }),
                                pagination: {
                                    more: data.current_page < data.last_page
                                }
                            };
                        },
                        cache: true
                    },
                });
            }

            // Fetch selected options and append them to the select
            if (typeof $selectedOptions !== typeof undefined && $selectedOptions !== false && $selectedOptions != '') {
                var optionsForSelect = [];
                select2AjaxMultipleFetchSelectedEntries(element).then(function (result) {
                    result.forEach(function (item) {
                        $itemText = item[$fieldAttribute];
                        $itemValue = item[$connectedEntityKeyName];
                        optionsForSelect.push($itemValue);
                        $(element).append('<option value="' + $itemValue + '" data-main="' + (item.is_main ? 'true' : 'false') + '">' + $itemText + '</option>');
                    });

                    $(element).val(optionsForSelect);
                });
            }

            // Handle dependencies
            for (var i = 0; i < $dependencies.length; i++) {
                var $dependency = $dependencies[i];
                if (typeof element.attr('data-custom-selector') == 'undefined') {
                    form.find('[name="' + $dependency + '"], [name="' + $dependency + '[]"]').change(function (el) {
                        $(element.find('option:not([value=""])')).remove();
                        element.val(null).trigger("change");
                    });
                } else {
                    let rowNumber = element.attr('data-row-number');
                    let selector = element.attr('data-custom-selector');
                    selector = selector.replaceAll('%DEPENDENCY%', $dependency).replaceAll('%ROW%', rowNumber);

                    $(selector).change(function (el) {
                        $(element.find('option:not([value=""])')).remove();
                        element.val(null).trigger("change");
                    });
                }
            }
        }
    </script>
@endpush
{{-- End of Extra CSS and JS --}}
{{-- ########################################## --}}
