<!-- html5 date input -->

<?php
// if the column has been cast to Carbon or Date (using attribute casting)
// get the value as a date string
if (isset($field['value']) && ($field['value'] instanceof \Carbon\CarbonInterface)) {
    $field['value'] = $field['value']->toDateString();
}
?>

@include('crud::fields.inc.wrapper_start')
    <label>{!! $field['label'] !!}</label>
    <div>
        @if(isset($field['value']))
            <a href="{{$field['data_source']}}/{{$field['value']}}/edit/">
                {{$field['ref_model']::find($field['value'])->title}}
            </a>
        @else
            <select name="{{$field['name']}}">
                @if (isset($field['allows_null']) && $field['allows_null']==true)
                    <option value="">{{__("app.original_contract")}}</option>

                    @foreach($field['ref_model']::all() as $contract)
                        <option value="{{$contract->id}}">{{$contract->title}}</option>
                    @endforeach

                @endif
            </select>
        @endif

    </div>

    {{-- HINT --}}
    @if (isset($field['hint']))
        <p class="help-block">{!! $field['hint'] !!}</p>
    @endif
@include('crud::fields.inc.wrapper_end')
