{{-- regular object attribute --}}
@php
    $value = data_get($entry, $column['name']);
    $column['text'] = is_string($value) ? $value : '';
    $column['escaped'] = $column['escaped'] ?? false;
    $column['prefix'] = $column['prefix'] ?? '';
    $column['suffix'] = $column['suffix'] ?? '';
    $column['limit'] = $column['limit'] ?? 50; // Limit to the number of characters to show

    if(!empty($column['text'])) {
        $column['text'] = $column['prefix'].$column['text'].$column['suffix'];
        $column['short_text'] = Str::limit($column['text'], $column['limit']);
        $column['is_truncated'] = Str::length($column['text']) > $column['limit'];
    }
@endphp

<div class="readmore-wrapper">
    @includeWhen(!empty($column['wrapper']), 'crud::columns.inc.wrapper_start')
    @if($column['escaped'])
        <div class="short-text">{{ $column['short_text'] }}</div>
        @if($column['is_truncated'])

            <div class="full-text" style="display:none;">{{ $column['text'] }}</div>
            <a href="#" class="read-more">Read More</a>
        @endif
    @else
        <div class="short-text">{!! $column['short_text'] !!}</div>
        @if($column['is_truncated'])

            <div class="full-text" style="display:none;">{!! $column['text'] !!}</div>
            <a href="#" class="read-more">Read More</a>
        @endif
    @endif
    @includeWhen(!empty($column['wrapper']), 'crud::columns.inc.wrapper_end')
    <hr class="mb-1 mt-1">


    <?php if(isset($entry->extradata->is_checkpoint)):?>

        <?php $check = \App\Models\Event::find($entry->extradata->is_checkpoint); ?>
        <a data-toggle="tooltip" title="<?php echo __("app.buttons.assigned",['event'=>$check->id])?>" href="<?php echo backpack_url('events/'.$check->id).'/edit'?>" class="btn btn-xs btn-link">
            <i class="bi bi-link"></i>
        </a>
    <?php endif?>

    <?php if(isset($entry->extradata->checkpoints)):?>
        @foreach($entry->extradata->checkpoints as $i=>$checkpoint)
        <?php $check = \App\Models\Event::find($checkpoint); ?>
        <a data-toggle="tooltip" title="<?php echo __("app.buttons.checkpoint_title",['checkpoint'=>$checkpoint])?>" href="<?php echo backpack_url('events/'.$checkpoint).'/edit'?>" class="btn btn-xs btn-link">
                <?php echo __("app.buttons.checkpoint")?> {{$i}} {!! $check->status ? '<i class="bi bi-circle"></i>' : '<i class="bi bi-check-circle-fill"></i>' !!}
        </a>
        @endforeach
    <?php endif?>

    <?php if(isset($entry->extradata->closed_by)):?>
    <a data-toggle="tooltip" title="<?php echo __("app.buttons.closed_by",['event'=>$entry->extradata->closed_by])?>" href="<?php echo backpack_url('events/'.$entry->extradata->closed_by).'/edit'?>" class="btn btn-xs btn-link">
            <?php echo __("app.buttons.closed_by_short")?> <i class="bi bi-check-square-fill"></i>
    </a>
    <?php elseif(isset($entry->extradata->closing)):?>
    <a data-toggle="tooltip" title="<?php echo __("app.buttons.closing",['event'=>$entry->extradata->closing])?>" href="<?php echo backpack_url('events/'.$entry->extradata->closing).'/edit'?>" class="btn btn-xs btn-link">
            <?php echo __("app.buttons.closes_short")?> <i class="bi bi-check-square"></i>
    </a>
    <?php endif?>


    <?php if(count($entry->event_files)):?>
    <a data-toggle="tooltip" title="<?php echo __("app.buttons.files",['files'=>count($entry->event_files)])?>" href="<?php echo backpack_url('events/'.$entry->id).'/edit#arkhia'?>" class="btn btn-xs btn-link">
        <i class="bi bi-folder-check"></i> <span class="badge badge-success">{{count($entry->event_files)}}</span>
    </a>
    <?php endif?>
</div>


