{{-- regular object attribute --}}
@php
    $checklist = json_decode(data_get($entry, $column['name']));
@endphp
@if($column['name']=='checklist')
<form method="post" action="{{backpack_url('checklists/sign/'.$entry->id)}}" class="flow-wrapper">
    {!! csrf_field() !!}
@endif
    @foreach($checklist as $row)

        <table class="table table-bordered table-condensed table-striped m-b-0">
            <caption>{{$row->title}}</caption>
            <thead>
            <tr>
                @if($column['name']=='checklist')
                <th width="90%">{{ __("app.database.task") }}</th>
                    <th width="10%">-</th>
                @else
                    <th width="50%">{{ __("app.database.ingredients_or_step") }}</th>
                    <th class="text-center">1</th>
                    <th class="text-center">2</th>
                    <th class="text-center">3</th>
                    <th class="text-center">4</th>
                    <th class="text-center">5</th>
                    <th class="text-center">6</th>
                    <th class="text-center">7</th>
                @endif
            </tr>
            </thead>
            <tbody>
            @foreach (json_decode($row->tasks) as $key=>$task)
                <tr>

                        <td>

                           {!! $task->name !!}

                        </td>
                    @if($column['name']=='checklist')
                        <td>
                            <input name="field[{{$row->title}}][{{$task->name}}]" value="0" type="hidden">
                            <input class="form-control" name="field[{{$row->title}}][{{$task->name}}]" value="1" type="checkbox">
                        </td>
                    @else
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                        <td><input class="text-center form-control" type="text" name="field[{{$row->title}}][{{$task->name}}][]" value="0"></td>
                    @endif
                </tr>
            @endforeach
            </tbody>
        </table>
    @endforeach
    @if($column['name']!='checklist')
    <button type="submit" class="btn btn-success flow-btn d-none">{{__("backpack::crud.save")}}</button>
</form>
@endif

