<!-- This file is used to store sidebar items, starting with Backpack\Base 0.9.0 -->
<li class="nav-item"><a class="nav-link" href="{{ backpack_url('dashboard') }}"><i class="la la-home nav-icon"></i> {{__("app.control_panel")}}</a></li>

<li class="nav-title">{{__("app.search")}} <i data-toggle="popover"  title="{{__("app.search_help_title")}}" data-content="{!! __("app.search_help_content") !!}" style="cursor: pointer" class="bi bi-info-circle-fill"></i></li>
<form action="{{backpack_url('search')}}" method="get">
    <div class="form-group row">
        <div class="col-12">
            <div class="input-group">
                <input type="search" class="form-control" value="{{request()->q}}" name="q" placeholder="{{__("app.search_placeholder")}}">
                <span class="input-group-append">
                    <button class="btn btn-primary" type="submit"><i class="bi bi-search"></i></button>
                </span>
            </div>
        </div>
    </div>
</form>
<li class="nav-title">{{__("app.options")}}</li>
@can("view events")
<li class='nav-item'><a class='nav-link' href='{{ backpack_url('events') }}'><i class="nav-icon bi bi-calendar-event"></i> <span>{{__("app.events")}}</span></a></li>
@endcan
@can('view contacts')
    <li class='nav-item'><a class='nav-link' href='{{ backpack_url('contacts') }}'><i class="nav-icon bi bi-person-lines-fill"></i> {{__("app.contacts")}}</a></li>
@endcan

@canany(['view manuals','view flows'])
<li class="nav-item nav-dropdown">
    <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon bi bi-patch-question-fill"></i> {{__("app.database.manuals_and_flows")}}</a>
    <ul class="nav-dropdown-items">
        @can('view manuals')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('manuals') }}'><i class="nav-icon bi bi-egg-fried"></i> {{__("app.database.manuals")}}</a></li>
        @endcan
        @can('view flows')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('checklists') }}'><i class='nav-icon la la-file-excel'></i> {{__("app.database.checklists")}}</a></li>
        @endcan
            @can('view static')
                <li class='nav-item'><a class='nav-link' href='{{ backpack_url('static') }}'><i class='nav-icon la la-file-text'></i> {{__("app.database.static")}}</a></li>
            @endcan
    </ul>
</li>
@endcanany


@canany(['view reports','view oscc'])
    <li class="nav-item nav-dropdown">
        <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon bi bi-clipboard-data"></i> {{__("app.reporting.reporting")}}</a>
        <ul class="nav-dropdown-items">
            @can('view oscc')
                <li class='nav-item'><a class='nav-link' href='{{ backpack_url('oscc') }}'><i class="nav-icon bi bi-calculator"></i> {{__("app.reporting.oscc")}}</a></li>
            @endcan
            @can('view reports')
{{--                <li class='nav-item'><a class='nav-link' href='{{ backpack_url('report1') }}'><i class='nav-icon bi bi-graph-up'></i> {{__("app.reporting.report1")}}</a></li>--}}
            @endcan
        </ul>
    </li>
@endcanany


@canany(["view banks","view companies","view expenses","view event types","view products","view projects","view project groups","view taxes"])
<li class="nav-item nav-dropdown">
    <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon bi bi-database"></i> {{__("app.database.database")}}</a>
    <ul class="nav-dropdown-items">




        @can('view stores')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('stores') }}'><i class='nav-icon bi bi-shop'></i> {{__("app.database.stores")}}</a></li>
        @endcan

        @can('view projectgroups')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('projectgroups') }}'><i class='nav-icon bi bi-collection'></i> {{__("app.database.project_groups")}}</a></li>
        @endcan

        @can('view projects')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('projects') }}'><i class='nav-icon bi bi-kanban'></i> {{__("app.database.projects")}}</a></li>
        @endcan

        @can('view event types')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('eventtypes') }}'><i class='nav-icon bi bi-braces-asterisk'></i> {{__("app.database.event_types")}}</a></li>
        @endcan



        @can('view banks')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('banks') }}'><i class='nav-icon la la-university'></i> {{__("app.database.banks")}}</a></li>
        @endcan

        @can('view companies')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('companies') }}'><i class='nav-icon la la-building'></i> {{__("app.database.companies")}}</a></li>
        @endcan

        @can('view expenses')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('costcenters') }}'><i class='nav-icon la la-money-bill-wave'></i> {{__("app.database.cost_centers")}}</a></li>
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('expenses') }}'><i class='nav-icon la la-money-bill-wave'></i> {{__("app.database.expenses")}}</a></li>
        @endcan

{{--        @can('view currencies')--}}
{{--            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('currencies') }}'><i class='nav-icon la la-coins'></i> Currencies</a></li>--}}
{{--        @endcan--}}



        @can('view professions')
            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('professions') }}'><i class='nav-icon la la-briefcase'></i> {{__("app.database.professions")}}</a></li>
        @endcan

{{--        @can('view products')--}}
{{--            <li class='nav-item'><a class='nav-link' href='{{ backpack_url('products') }}'><i class='nav-icon la la-box'></i> Products</a></li>--}}
{{--        @endcan--}}



    </ul>
</li>
@endcanany



@can('view elfinder')
    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('elfinder') }}"><i class="nav-icon bi bi-files"></i> <span>{{ trans('backpack::crud.file_manager') }}</span></a></li>
@endcan

@canany(["view users","view roles","view permissions"])
    <li class="nav-item nav-dropdown">
        <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon bi bi-person-gear"></i> {{__("app.users.user_management")}}</a>
        <ul class="nav-dropdown-items">
            @can("view users")
                <li class='nav-item'><a class='nav-link' href='{{ backpack_url('user') }}'><i class='nav-icon bi bi-people'></i> <span>{{__("app.users.users")}}</span></a></li>
            @endcan
            @can("view roles")
                <li class="nav-item"><a class="nav-link" href="{{ backpack_url('role') }}"><i class="nav-icon bi bi-person-vcard"></i> <span>{{__("app.users.roles")}}</span></a></li>
            @endcan
            @can("view permissions")
                <li class="nav-item"><a class="nav-link" href="{{ backpack_url('permission') }}"><i class="nav-icon bi bi-person-slash"></i> <span>{{__("app.users.permissions")}}</span></a></li>
            @endcan
            @can("view userfields")
                <li class="nav-item"><a class="nav-link" href="{{ backpack_url('fields') }}"><i class="nav-icon la la-id-badge"></i> <span>{{__("app.users.user_fields")}}</span></a></li>
            @endcan
        </ul>
    </li>
@endcanany

@canany(["view logs","view audit","view backups"])
    <li class="nav-item nav-dropdown">
        <a class="nav-link nav-dropdown-toggle" href="#"><i class="nav-icon bi bi-cpu"></i> {{__("app.system.system")}}</a>
        <ul class="nav-dropdown-items">
            @can("view logs")
                <li class="nav-item"><a class="nav-link" href="{{ backpack_url('log') }}"><i class="nav-icon bi bi-terminal"></i> <span>{{__("app.system.logs")}}</span></a></li>
            @endcan
            @can("view backups")
                    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('backup') }}"><i class="nav-icon bi bi-safe"></i> <span>{{__("app.system.backups")}}</span></a></li>
            @endcan
{{--            @can("view audit")--}}
{{--                    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('audit') }}"><i class="nav-icon la la-terminal"></i> <span>{{__("app.system.audit")}}</span></a></li>--}}
{{--            @endcan--}}
        </ul>
    </li>
@endcanany
@can('view announcements')
    <li class="nav-item"><a class="nav-link" href="{{ backpack_url('announcements') }}"><i class="nav-icon bi bi-megaphone"></i> <span>{{ __("app.announcements") }}</span></a></li>
@endcan

<li style="margin-top: auto;position: sticky;bottom: 0;border-top:1px dotted #eee" >
    <h4 class="dropdown-header text-white" title="{{__("app.licenced_to")}} {{env("INSURANCER_LICENCED_TO")}}"><i class="la la-file-contract" ></i> {{env("INSURANCER_LICENCED_TO")}} <a title="KMS v2 Manual" data-toggle="tooltip" target="_blank" href="{{asset("manual.pdf")}}"><i class="la la-life-ring"></i></a></h4>
    <h5 class="dropdown-header text-white-50">{!! env("POWERED_BY") !!}</h5>

</li>

