@extends(backpack_view('blank'))

@php
//    $widgets['before_content'][] = [
//        'type'        => 'jumbotron',
//        'heading'     => trans('backpack::base.welcome'),
//        'content'     => trans('backpack::base.use_sidebar'),
//        'button_link' => backpack_url('logout'),
//        'button_text' => trans('backpack::base.logout'),
//    ];
@endphp

@section('content')
    <div class="animated fadeIn">
        <div class="row">
            <div class="col-12">
                @foreach(user()->announcements as $announcement)

                    <div class="card bg-{{$announcement->lvl ?? 'info'}} text-white">
                        <div class="card-header"><b>{{$announcement->title}}</b>
                            <div class="card-header-actions">
                                <a class="card-header-action btn-close" href="{{backpack_url('announcements/'.$announcement->id.'/dismiss')}}" onclick="return confirm('{{__("app.delete_confirm")}}')" class="btn btn-link text-danger">&times;</a></div>
                        </div>
                        <div class="collapse show" id="collapseExample">
                            <div class="card-body">{!! $announcement->content !!}</div>
                        </div>
                    </div>

                @endforeach
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-lg-3">
                <div class="card text-white bg-primary">
                    <div class="card-body pb-0">
                        <div class="btn-group float-right">
{{--                            <button class="btn btn-transparent dropdown-toggle p-0" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-settings"></i></button>--}}
{{--                            <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Action</a><a class="dropdown-item" href="#">Another action</a><a class="dropdown-item" href="#">Something else here</a></div>--}}
                        </div>
                        <div class="text-value">{{\App\Models\Contact::count()}}</div>
                        <div>{{__("app.contacts")}}</div>
                    </div>

                </div>
            </div>
            <!-- /.col-->
            <div class="col-sm-6 col-lg-3">
                <div class="card text-white bg-success">
                    <div class="card-body pb-0">
{{--                        <button class="btn btn-transparent p-0 float-right" type="button"><i class="icon-location-pin"></i></button>--}}
                        <div class="text-value">{{\App\Models\User::count()}}</div>
                        <div>{{__("app.users.users")}}</div>
                    </div>

                </div>
            </div>
            <!-- /.col-->
            <div class="col-sm-6 col-lg-3">
                <div class="card text-white bg-warning">
                    <div class="card-body pb-0">
                        <div class="btn-group float-right">
{{--                            <button class="btn btn-transparent dropdown-toggle p-0" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-settings"></i></button>--}}
{{--                            <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Action</a><a class="dropdown-item" href="#">Another action</a><a class="dropdown-item" href="#">Something else here</a></div>--}}
                        </div>
                        <div class="text-value">{{\App\Models\Event::active()->valid()->count()}}</div>
                        <div>{{__("app.my_events")}}</div>
                    </div>

                </div>
            </div>
            <!-- /.col-->
            <div class="col-sm-6 col-lg-3">
                <div class="card text-white bg-dark">
                    <div class="card-body pb-0">
                        <div class="btn-group float-right">
{{--                            <button class="btn btn-transparent dropdown-toggle p-0" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="icon-settings"></i></button>--}}
{{--                            <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Action</a><a class="dropdown-item" href="#">Another action</a><a class="dropdown-item" href="#">Something else here</a></div>--}}
                        </div>
                        <div class="text-value">{{\App\Models\Event::valid()->thisMonth()->count()}}</div>
                        <div>{{__("app.expiring_this_month")}}</div>
                    </div>

                </div>
            </div>
            <!-- /.col-->
        </div>
        <!-- /.row-->
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-5">
                        <h4 class="card-title mb-0">{{__("app.new_contracts_this_month_per_day")}}</h4>
                        <div class="small text-muted">{{\Illuminate\Support\Carbon::now()->translatedFormat('F')}} {{\Illuminate\Support\Carbon::now()->format('Y')}}</div>
                    </div>
                    <!-- /.col-->
                    <!-- /.col-->
                </div>
                <!-- /.row-->
                <div class="chart-wrapper" style="height:300px;margin-top:40px;">
                    <div class="chart" id="events_per_day" height="300"></div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row text-center">
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">{{__("app.database.companies")}}</div><strong>{{\App\Models\Company::count()}} </strong>
{{--                        <div class="progress progress-xs mt-2">--}}
{{--                            <div class="progress-bar bg-success" role="progressbar" style="width: 40%" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100"></div>--}}
{{--                        </div>--}}
                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">{{__("app.database.stores")}}</div><strong>{{\App\Models\Store::count()}}</strong>

                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">{{__("app.database.manuals")}}</div><strong>{{\App\Models\Manual::count()}}</strong>

                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">{{__("app.database.static")}}</div><strong>{{\App\Models\StaticContent::count()}}</strong>

                    </div>
                    <div class="col-sm-12 col-md mb-sm-2 mb-0">
                        <div class="text-muted">{{__("app.database.checklists")}}</div><strong>{{\App\Models\Checklist::count()}}</strong>

                    </div>
                </div>
            </div>
        </div>
        <!-- /.card-->
        <!-- /.row-->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">{{__("app.events_per_type")}}</div>
                    <div class="card-body">
                        <div class="row">
                            @foreach(\App\Models\EventType::all() as $type)
                                @if($type->events()->count())
                                <div class="col-6 col-lg-3">
                                    <div class="card">
                                        <div class="card-body p-3 d-flex align-items-center">
                                            <i class="bg-primary p-3 font-2xl mr-3 {{$type->icon ?? 'la la-terminal'}}"></i>
                                            <div>
                                                <div class="text-value-sm text-primary">{{$type->events()->count()}}</div>
                                                <div class="text-muted text-uppercase font-weight-bold small">{{$type->title}}</div>
                                                <div class="text-muted small">{{$type->description}}</div>
                                            </div>
                                        </div>
                                        <a href="{{backpack_url('events')}}?eventtype={{$type->id}}" class="stretched-link"></a>
                                    </div>
                                </div>
                                @endif
                            @endforeach
                        </div>

                        <!-- /.row-->
                    </div>
                </div>

            </div>
            <!-- /.col-->
        </div>
        <!-- /.row-->
    </div>
@endsection


@section("after_scripts")
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

    <script>
        google.charts.load('current', {packages: ['corechart', 'bar']});
        google.charts.setOnLoadCallback(loadContracts);

        function loadContracts() {
            var data = new google.visualization.DataTable();
            data.addColumn('string', '{{__("app.date")}}');
            data.addColumn('number', '{{__("app.events")}}');

            @php
                error_reporting(E_ERROR);
                $days = [];
                foreach (\App\Models\Event::whereYear("created_at",date("Y"))->whereMonth("created_at",date("m"))->orderBy('created_at')->get() as $contract){
//                    dd($contract);
                    $days[$contract->created_at->format('d-m-Y')]++;
                }
            @endphp



            data.addRows([
                    @foreach($days as $date=>$count)
                ["{{$date}}", {{$count}}] @if(!$loop->last),@endif
                @endforeach
            ]);

            var options = {
                title: '{{__("app.contracts_per_day")}}',
                colors: ['#9575cd'],
                hAxis: {
                    title: '{{__("app.timeline")}}',

                },
                vAxis: {
                    title: '{{__("app.new_contracts_this_month_per_day")}}'
                }
            };

            var chart = new google.visualization.ColumnChart(document.getElementById('events_per_day'));
            chart.draw(data, options);
        }
    </script>
@endsection
