@extends(backpack_view('blank'))


@section('content')
    <div class="col-12 mb-4">
        <ul class="nav nav-tabs" role="tablist">
            @foreach($results as $title=>$items)
                @if($items->count())
                <li class="nav-item">
                    <a class="nav-link @if($loop->first)active @endif" data-toggle="tab" href="#result_{{md5($title)}}" role="tab" aria-controls="home">
                        <i class="bi bi-dot"></i> {{$title}} &nbsp;
                        <span class="badge badge-success">{{$items->count()}}</span>
                    </a>
                </li>
                @endif
            @endforeach
        </ul>
        <div class="tab-content">
            @foreach($results as $title=>$items)
                @if($items->count())
            <div class="tab-pane @if($loop->first)active @endif" id="result_{{md5($title)}}" role="tabpanel">
                <table class="table table-responsive-sm">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__("app.item")}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($items as $item)
                        <tr>
                            <td>{{$item->id}}</td>
                            <td>{!! $item !!}</td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>
            </div>
                @endif
            @endforeach
        </div>
    </div>
@endsection