@extends(backpack_view('blank'))


@section('content')
    <div id='calendar'></div>

@endsection


@section("after_scripts")
    <script>

        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: [ 'dayGrid', 'timeGrid', 'list', 'bootstrap', 'interaction' ],
                timeZone: 'UTC',
                locale: '{{app()->getLocale()}}',
                selectable: true,
                selectHelper: true,

                themeSystem: 'bootstrap5',
                {{--customButtons: {--}}
                {{--    exportIcal: {--}}
                {{--        text: '{{__("app.calendar.export_calendar")}}',--}}
                {{--        click: function() {--}}
                {{--            document.location = "{{backpack_url("calendar/export")}}"--}}
                {{--        }--}}
                {{--    }--}}
                {{--},--}}

                header: {
                    left: 'prev,next',
                    center: 'title',
                    right: 'today,dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                },
                weekNumbers: false,
                eventLimit: true, // allow "more" link when too many events
                events: '{{backpack_url('calendar/events')}}',
                // eventRender: function(event, element){
                //     element.popover({
                //         animation:true,
                //         delay: 300,
                //         content: '<b>Inicio</b>:',
                //         trigger: 'hover'
                //     });
                // },
            });


            calendar.on('select', function(info) {

                document.location = "{{backpack_url('events/create/?scheduled_for=')}}"+info.startStr;

            });


            calendar.render();
        });


    </script>
@endsection