@extends(backpack_view('blank'))

@section("content")
    <div class="task_{{ $task->progress }}">
        <div class="jumbotron mb-2">
            
            
            <h1 class="display-3">{!! $task->title !!}</h1>
       
            <p>{{ $task->description }}</p>
            <p class="text-muted">
                <i class="fa fa-calendar">{{___("from_date")}} {{$task->start_date}}</i>
            </p>
            <p class="text-muted">
                <i class="fa fa-calendar">{{___("to_date")}} {{$task->due_date}}</i>
            </p>
    
            <b>{{___("change_task_progress")}}</b><br>
            <div class="btn-group" role="group" aria-label="{{___("change_task_progress")}}">
                <button data-progress="not_started" class="btn progress-update @if($task->progress=='not_started')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_not_started")}}</button>
                <button data-progress="in_progress" class="btn progress-update @if($task->progress=='in_progress')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_in_progress")}}</button>
                <button data-progress="alpha" class="btn progress-update @if($task->progress=='alpha')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_alpha")}}</button>
                <button data-progress="beta" class="btn progress-update @if($task->progress=='beta')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_beta")}}</button>
                <button data-progress="release" class="btn progress-update @if($task->progress=='release')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_release")}}</button>
                <button data-progress="review" class="btn progress-update @if($task->progress=='review')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_review")}}</button>
                <button data-progress="complete" class="btn progress-update @if($task->progress=='complete')btn-outline-primary @else btn-secondary @endif" type="button">{{___("task_text_complete")}}</button>
            </div>
            
        </div>
    </div>
@endsection


@section("after_scripts")
    <script>
        jQuery(document).on("click",".progress-update",function () {
            el = jQuery(this);
            jQuery.post("{{backpack_url('calendar/'.$task->id.'/update')}}",{
                progress: el.data("progress")
            },function (res) {
                new Noty({
                    type: "success",
                    text: "{{___("task_progress_updated_succesfully")}}"
                }).show();
                jQuery(".progress-update").removeClass('btn-outline-primary').removeClass('btn-secondary').addClass('btn-secondary');
                el.removeClass('btn-secondary').addClass("btn-outline-primary");
            });
        });
    </script>
@endsection