@extends(backpack_view('blank'))


@section('content')
    <div id='calendar'></div>
@endsection


@section("after_scripts")
    <script>

        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: [ 'dayGrid', 'timeGrid', 'list', 'bootstrap', 'interaction' ],
                timeZone: 'UTC',
                locale: '{{app()->getLocale()}}',
                selectable: true,
                themeSystem: 'bootstrap',
                customButtons: {
                    importGoogle: {
                        text: '{{__("backend.import_calendar_from_google")}}',
                        click: function() {


                            Swal.fire({
                                title: "{{__("backend.fill_in_calendar_endpoint_url")}}",
                                input: 'url',

                                showCancelButton: true,
                                confirmButtonText: '{{___("save")}}',
                                cancelButtonText: '{{___("cancel")}}',
                                showLoaderOnConfirm: true
                            }).then((result) => {
                                console.debug(result);
                                //https://calendar.google.com/calendar/ical/basdog22%40gmail.com/private-e5e6c8ba96c527c30300f87802393938/basic.ics
                                if(result.value.trim()){
                                    $.post("{{backpack_url("calendar/importics")}}", {
                                        endpoint: result.value,
                                    }, function (response) {
                                        if(response.success){
                                            new Noty({
                                                type: "success",
                                                text: "{{__("backend.tasks_imported_succesfully")}}"
                                            }).show();

                                            calendar.refetchEvents();
                                        }else{
                                            new Noty({
                                                type: "error",
                                                text: "{{__("backend.tasks_not_imported")}}"
                                            }).show();
                                        }
                                    });
                                }
                            })





                        }
                    },exportIcal: {
                        text: '{{__("backend.export_calendar")}}',
                        click: function() {
                            document.location = "{{backpack_url("calendar/export")}}"
                        }
                    }
                },
                header: {
                    left: 'prev,next importGoogle exportIcal',
                    center: 'title',
                    right: 'today,dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                },
                weekNumbers: false,
                eventLimit: true, // allow "more" link when too many events
                events: '{{backpack_url('calendar/events')}}',
            });

            calendar.on('select', function(info) {
                
                
                
                jQuery("#alertboxfields").remove();
                
                jQuery('<div id="alertboxfields">' +
                    '<div class="form-group"><label for="swal-input-title">{{___("title")}}:</label><input value="" id="swal-input-title" class="form-control"></div>' +
                    '<div class="form-group"><label for="swal-input-link">{{___("link")}}:</label><input value="" id="swal-input-link" class="form-control"></div>' +
                    '<div class="form-group"><label for="swal-input-description">{{___('description')}}:</label><textarea id="swal-input-description" class="form-control"></textarea></div>' +
                    '<div class="form-group"><label for="swal-input-progress">{{___("progress")}}:</label><select id="swal-input-progress" class="form-control">' +
                    '<option value="not_started">{{___("task_text_not_started")}}</option>' +
                    '<option value="in_progress">{{___("task_text_in_progress")}}</option>' +
                    '<option value="alpha">{{___("task_text_alpha")}}</option>' +
                    '<option value="beta">{{___("task_text_beta")}}</option>' +
                    '<option value="release">{{___("task_text_release")}}</option>' +
                    '<option value="review">{{___("task_text_review")}}</option>' +
                    '<option value="complete">{{___("task_text_complete")}}</option>' +
                    '</select></div>' +
                    '<div class="form-group"><label for="swal-input-start">{{___("start_date")}}:</label><input type="date" value="' + info.startStr + '" id="swal-input-start" class="form-control"></div>' +
                    '<div class="form-group"><label for="swal-input-end">{{___("end_date")}}:</label><input type="date" value="' + info.endStr + '" id="swal-input-end" class="form-control"></div>' +
                    '</div>').appendTo("body");
                
                var cont = document.getElementById('alertboxfields');
                
                
                Swal.fire({
                    title: "{{__("backend.add_new_task")}}",
                    icon: "info",
                    width: 450,

                    showCancelButton: true,
                    confirmButtonText: '{{___("save")}}',
                    cancelButtonText: '{{___("cancel")}}',
                    showLoaderOnConfirm: true,
                    html: cont
                }).then(
                    (result) => {
                        console.debug(result)
                        if (result.isConfirmed) {
                            if ($("#swal-input-title").val().trim() != '' && $("#swal-input-start").val().trim() != '' && $("#swal-input-end").val().trim() != '') {
                                $.post("{{backpack_url("calendar/create")}}", {
                                    title: $("#swal-input-title").val(),
                                    link: $("#swal-input-link").val(),
                                    description: $("#swal-input-description").val(),
                                    progress: $("#swal-input-progress").val(),
                                    start: $("#swal-input-start").val(),
                                    end: $("#swal-input-end").val(),
                                }, function (result) {
                                    if(result.id){
                                        new Noty({
                                            type: "success",
                                            text: "{{__("backend.task_created_succesfully")}}"
                                        }).show();
                                        
                                    calendar.refetchEvents();

                                    }
                                });
                            } else {
                                Swal.fire({
                                    title: '{!! __("backend.please_fill_in_date_and_title") !!}',
                                    icon: "warning",
                                }).then((value)=>{
                                    calendar.select(info.startStr,info.endStr)
                                });
                                
                                
                                
                            }
                        }else{
                            console.info(result);
                        }
                    }
                );
            });
            calendar.render();
        });


    </script>
@endsection