<?php


use App\Events\EventCreated;
use App\Models\Brand;
use App\Models\Company;
use App\Models\Contact;
use App\Models\Event;
use App\Models\EventType;
use App\Models\Vehicle;
use App\Models\Vehicletype;
use BeyondCode\Mailbox\Facades\Mailbox;
use BeyondCode\Mailbox\InboundEmail;
use Illuminate\Support\Carbon;
use Khsing\World\World;

date_default_timezone_set('Europe/Athens');
setlocale(LC_TIME, 'el_GR.UTF-8');
\Illuminate\Support\Carbon::setLocale('el_GR');


function user($id=null){
	return $id ? \App\Models\User::find($id) : backpack_user();
}

function oldOrValue($object, $attr) {
    return $object->$attr ?? old($attr);
}
function isJson($string) {
    return is_string($string) && Str::startsWith($string,['[','{']) && Str::endsWith($string,[']','}']);
}



function months(): array
{
    return [
        1 => __("app.january"),
        2 => __("app.february"),
        3 => __("app.march"),
        4 => __("app.april"),
        5 => __("app.may"),
        6 => __("app.june"),
        7 => __("app.july"),
        8 => __("app.august"),
        9 => __("app.september"),
        10 => __("app.october"),
        11 => __("app.november"),
        12 => __("app.december"),
    ];
}


function years()
{

    $thisYear = \Illuminate\Support\Carbon::now()->year;
    $lastYear = $thisYear - 1;
    $nextYear = $thisYear + 1;
    $twoYears = $nextYear + 1;
    return [
        $lastYear => __("app.last_year", ['year' => $lastYear]),
        $thisYear => __("app.this_year", ['year' => $thisYear]),
        $nextYear => __("app.next_year", ['year' => $nextYear]),
        $twoYears => __("app.two_years", ['year' => $twoYears]),
    ];
}





function parseAADEtoJSON($aade)
{
    // Create a DOMDocument object
    $doc = new \DOMDocument();

    // Load XML string into the DOMDocument
    $doc->loadXML($aade);

    // Create an XPath object
    $xpath = new \DOMXPath($doc);

    // Register the namespaces
    $xpath->registerNamespace('env', 'http://www.w3.org/2003/05/soap-envelope');
    $xpath->registerNamespace('srvc', 'http://rgwspublic2/RgWsPublic2');

    // Use XPath to query the XML for basic_rec
    $basicRecNode = $xpath->query('//*[local-name()="basic_rec"]')->item(0);
    $sec = $xpath->query('//*[local-name()="firm_act_descr"]')->item(0);
    $json = [];
    // Parse children of basic_rec into PHP variables
    $json['afm'] = $basicRecNode->getElementsByTagName('afm')->item(0)->nodeValue;
    $json['doy'] = $basicRecNode->getElementsByTagName('doy')->item(0)->nodeValue;
    $json['doyDescr'] = $basicRecNode->getElementsByTagName('doy_descr')->item(0)->nodeValue;
    $json['iNiFlagDescr'] = $basicRecNode->getElementsByTagName('i_ni_flag_descr')->item(0)->nodeValue;
    $json['deactivationFlag'] = $basicRecNode->getElementsByTagName('deactivation_flag')->item(0)->nodeValue;
    $json['deactivationFlagDescr'] = $basicRecNode->getElementsByTagName('deactivation_flag_descr')->item(0)->nodeValue;
    $json['firmFlagDescr'] = $sec->nodeValue ?? $basicRecNode->getElementsByTagName('firm_flag_descr')->item(0)->nodeValue;
    $json['onomasia'] = $basicRecNode->getElementsByTagName('onomasia')->item(0)->nodeValue;
    $json['commerTitle'] = $basicRecNode->getElementsByTagName('commer_title')->item(0)->nodeValue;
    $json['legalStatusDescr'] = $basicRecNode->getElementsByTagName('legal_status_descr')->item(0)->nodeValue;
    $json['postalAddress'] = $basicRecNode->getElementsByTagName('postal_address')->item(0)->nodeValue;
    $json['postalAddressNo'] = $basicRecNode->getElementsByTagName('postal_address_no')->item(0)->nodeValue;
    $json['postalZipCode'] = $basicRecNode->getElementsByTagName('postal_zip_code')->item(0)->nodeValue;
    $json['postalAreaDescr'] = $basicRecNode->getElementsByTagName('postal_area_description')->item(0)->nodeValue;
    $json['registDate'] = $basicRecNode->getElementsByTagName('regist_date')->item(0)->nodeValue;
    $json['stopDate'] = $basicRecNode->getElementsByTagName('stop_date')->item(0)->nodeValue;
    $json['normalVatSystemFlag'] = $basicRecNode->getElementsByTagName('normal_vat_system_flag')->item(0)->nodeValue;

    return json_encode($json);
}


function get_from_aade($afm){

    //ftiaxnoume kwdikous sto https://www1.aade.gr/sgsisapps/tokenservices/protected/displayConsole.htm
    $url = 'https://www1.gsis.gr/wsaade/RgWsPublic2/RgWsPublic2';
    $wsdl = 'https://www1.gsis.gr/wsaade/RgWsPublic2/RgWsPublic2?WSDL';

    $xmlRequest = '
<env:Envelope xmlns:env="http://www.w3.org/2003/05/soap-envelope" xmlns:ns1="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:ns2="http://rgwspublic2/RgWsPublic2Service" xmlns:ns3="http://rgwspublic2/RgWsPublic2">
   <env:Header>
      <ns1:Security>
         <ns1:UsernameToken>
            <ns1:Username>'. config("aade.username") .'</ns1:Username>
            <ns1:Password>'. config("aade.password") .'</ns1:Password>
         </ns1:UsernameToken>
      </ns1:Security>
   </env:Header>
   <env:Body>
      <ns2:rgWsPublic2AfmMethod>
         <ns2:INPUT_REC>
            <ns3:afm_called_by/>
            <ns3:afm_called_for>'.$afm.'</ns3:afm_called_for>
         </ns2:INPUT_REC>
      </ns2:rgWsPublic2AfmMethod>
   </env:Body>
</env:Envelope>
';

    $headers = array(
        "Content-type: application/soap+xml; charset=utf-8",
        "Accept: text/xml",
        "Cache-Control: no-cache",
        "Pragma: no-cache",
        "SOAPAction: \"run\"",
        "Content-length: ".strlen($xmlRequest),
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlRequest);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    return $response;
}

function checkVIES($country,$taxcode){
    $url = "https://ec.europa.eu/taxation_customs/vies/rest-api/ms/$country/vat/$taxcode";

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, false);

    $response = curl_exec($ch);

    curl_close($ch);

    if ($response === false) {
        return false;
    } else {
        $data = json_decode($response, true);

        if (isset($data['isValid'])) {
            if ($data['isValid'] == true) {
                return $data;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}

function generateThumbnail($filePath)
{
    $fileInfo = pathinfo($filePath);
    $extension = strtolower($fileInfo['extension']);

    switch ($extension) {
        case 'jpg':
        case 'jpeg':
        case 'png':
        case 'gif':
            return createImageThumbnail($filePath);
        case 'pdf':
            return displayIcon('la-file-pdf');
        case 'doc':
        case 'docx':
            return displayIcon('la-file-word');
        case 'xls':
        case 'xlsx':
            return displayIcon('la-file-excel');
        case 'ppt':
        case 'pptx':
            return displayIcon('la-file-powerpoint');
        default:
            return displayIcon('la-file');
    }
}

function createImageThumbnail($filePath)
{
    return '<img src="' . asset($filePath) . '" alt="Thumbnail">';
}

function displayIcon($iconClass)
{
    return '<i class="la ' . $iconClass . ' la-3x"></i>';
}



function alert($msg,$method='success') {
    \Alert::$method($msg)->flash();
}




function manage_mailbox() {
    Mailbox::cc(env("MAILBOX_EMAIL"), function (InboundEmail $email) {

        $contact_id = 0;
        $creator_id = 0;
        $store_id = null;

        //creator is the user from the contact of the sender
        $creator = Contact::where('emails','like','%'.$email->from().'%')->first();




        if(!is_null($creator)){
            $creator_id = $creator->user?->id ?? 0;
            if($creator_id){
                $store_id = $creator->user?->store_id ?? null;
            }
        }


        $contact = Contact::where('emails','like','%'.$email->to()[0]->getEmail().'%')->first();

        if(!is_null($contact)){
            $contact_id = $contact->id;
        }


        $event = new Event();
        $event->creator_id = $creator_id;
        $event->store_id = $store_id;
        $event->contact_id = $contact_id;
        $event->event_type_id = EventType::whereTitle('EI')->first()->id;
        $event->project_group_id = null;
        $event->project_id = null;
        $event->cost_center_id = null;
        $event->expense_id = null;
        $event->value = 1;
        $event->status = 0;
        $event->event_files = null;
        $event->scheduled_for = Carbon::now();
        $event->notes = $email->subject();
        $event->extras = json_encode(['content'=>$email->html(),'recurring'=>'']);
        $event->save();



        foreach ($email->to() as $main){
            //recipient is set as main contact
            $recipient = Contact::where('emails','LIKE','%'.$main->getEmail().'%')->first() ?? Contact::first();
            $event->contacts()->attach($recipient,['is_main'=>1]);
        }


        //get all cc and add them as contacts
        foreach ($email->cc() as $cc){
            $emailAddress = $cc->getEmail();

            if($emailAddress!=env('MAILBOX_EMAIL')){
                $contact = Contact::where("emails",'LIKE','%'.$emailAddress.'%')->first();
                if(!is_null($contact) && !$event->contacts()->where('contact_id',$contact->id)->exists()){
                    $event->contacts()->attach($contact);
                }
            }
        }

        $files =  $event->event_files;
        //get all attachments and save them
        foreach ($email->attachments() as $attachment){
            $filename = $attachment->getFilename();
            $disk = "public";
            $destination_path = "/events/".date("Y")."/".date("m");

            $attachment->saveContent(storage_path('app/public'.$destination_path.'/'.$filename));
            $files[] = $destination_path.'/'.$filename;
        }

        if(count($files)){
            $event->setTheFilesManualy($files);
            $event->save();
        }
        //trigger any actions for this event
        EventCreated::dispatch($event);
    });
}

function selected_period() {
    $dateRange = request()->has('daterange') ? request()->daterange : \Illuminate\Support\Carbon::now()->startOfMonth()->format('d/m/Y')."-".\Illuminate\Support\Carbon::now()->endOfMonth()->format("d/m/Y");



    $dateRange = explode("-",$dateRange);
    $dateStart = Carbon::createFromFormat('d/m/Y',trim($dateRange[0]));
    $dateEnd = Carbon::createFromFormat('d/m/Y',trim($dateRange[1]));

    return [$dateStart,$dateEnd];
}
