<?php

namespace App\Providers;

use App\Http\Controllers\Pages;
use App\Models\Contact;
use App\Models\Event;
use App\Models\EventType;
use Backpack\PageManager\app\Http\Controllers\Admin\PageCrudController;
use Backpack\PermissionManager\app\Http\Controllers\RoleCrudController;
use Backpack\PermissionManager\app\Http\Controllers\UserCrudController;
use BeyondCode\Mailbox\Facades\Mailbox;
use BeyondCode\Mailbox\InboundEmail;
use Illuminate\Support\Carbon;
use Illuminate\Support\ServiceProvider;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
//        $this->app->bind(PageCrudController::class, Pages::class);
        $this->app->bind(UserCrudController::class, \App\Http\Controllers\UserCrudController::class);
        $this->app->bind(RoleCrudController::class, \App\Http\Controllers\RoleCrudController::class);


        $this->app->bind('path.public', function() {
            return base_path().'/../public_html';
        });

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        CRUD::macro('addTab', function ($tabName) {
            if (!isset($this->tabs)) {
                $this->tabs = [];
            }
            if (!in_array($tabName, $this->tabs)) {
                $this->tabs[] = $tabName;
            }
        });

        manage_mailbox();
    }
}
