<?php

namespace App\Operations;

use App\Constants\Roles;
use Illuminate\Support\Facades\Route;

trait TruncateOperation{


    protected function setupTruncateRoutes($segment, $routeName, $controller)
    {
        Route::post($segment.'/truncate', [
            'as'        => $routeName.'.truncate',
            'uses'      => $controller.'@truncate',
            'operation' => 'truncate',
        ]);
    }

    protected function setupTruncateDefaults()
    {
        $this->crud->allowAccess('truncate');


        $this->crud->operation(['list'], function () {
//            if(user()->hasRole(Roles::ROOT)){
                $this->crud->addButtonFromView('bottom','reset', 'reset', 'beginning');
//            }
        });
    }


    public function truncate(){
        $this->crud->model->truncate();
        \Alert::success("Truncated")->flash();
        return back();
    }
}