<?php

namespace App\Operations;

use Illuminate\Support\Facades\Route;

trait ToggleOperation{


    protected function setupToggleRoutes($segment, $routeName, $controller)
    {

        Route::post($segment.'/{id}/toggle', [

            'as'        => $routeName.'.toggle',
            'uses'      => $controller.'@toggle',
            'operation' => 'toggle',
            'middleware'=>  'role:Administrator',
        ]);
    }

    protected function setupToggleDefaults()
    {
        $this->crud->allowAccess('toggle');


        $this->crud->operation(['list','show'], function () {
            $this->crud->addButtonFromView('line','toggle', 'toggle', 'end');
        });
    }


    public function toggle($id){
        $entry = $this->crud->model->findOrFail($id);
        if(isset($entry->no_delete) && in_array($entry->name,$entry->no_delete)){
            \Alert::error("Can't change status on this item")->flash();
        }else{
            $entry->status = ($entry->status==1)?0:1;
            $entry->save();
            \Alert::info(___("status_changed"))->flash();
        }

        return back();
    }
}