<?php

namespace App\Operations;

use Illuminate\Support\Facades\Route;

trait BulkToggleOperation
{
    /**
     * Define which routes are needed for this operation.
     *
     * @param string $segment    Name of the current entity (singular). Used as first URL segment.
     * @param string $routeName  Prefix of the route name.
     * @param string $controller Name of the current CrudController.
     */
    protected function setupBulkToggleRoutes($segment, $routeName, $controller)
    {
        Route::post($segment.'/bulk-toggle', [
            'as'        => $routeName.'.bulkToggle',
            'uses'      => $controller.'@bulkToggle',
            'operation' => 'bulkToggle',
        ]);


    }

    /**
     * Add the default settings, buttons, etc that this operation needs.
     */
    protected function setupBulkToggleDefaults()
    {
        $this->crud->allowAccess('bulkToggle');

        $this->crud->operation('bulkToggle', function () {
            $this->crud->loadDefaultOperationSettingsFromConfig();
        });

        $this->crud->operation('list', function () {
            $this->crud->enableBulkActions();
            $this->crud->addButton('bottom', 'bulk_toggle', 'view', 'crud::buttons.bulk_toggle');
        });
    }

    /**
     * Delete multiple entries in one go.
     *
     * @return string
     */
    public function bulkToggle()
    {
        $this->crud->hasAccessOrFail('bulkToggle');

        $entries = $this->request->input('entries');
        $toggledEntries = [];

        foreach ($entries as $key => $id) {
            if ($entry = $this->crud->model->find($id)) {

                if(isset($entry->no_delete) && in_array($entry->name,$entry->no_delete)){
                    \Alert::error("Can't change status on this item:".$entry->id)->flash();
                }else{
                    $entry->status = ($entry->status==1)?0:1;
                    $toggledEntries[] = $entry->save();
                }



            }
        }

        return $toggledEntries;
    }
}
