<?php

namespace App\Models;

use App\Scopes\Storescope;
use App\Traits\Uuid;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Backpack\PermissionManager\app\Models\Role;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;


class User extends Authenticatable
{
    use Notifiable,HasRoles,CrudTrait,Uuid;
    use Uuid{
        boot as traitBoot;
    }
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static function search($q) {
        return self::where('name','LIKE','%'.$q.'%')->orWhere('email',$q)->get();
    }

    function __toString() {
        return "<a href='".backpack_url('user/'.$this->id.'/edit')."' class='btn btn-link'>{$this->name}</a>";
    }

//    protected static function boot()
//    {
//        parent::boot();
//        self::traitBoot();
//        static::addGlobalScope(new Storescope());
//    }

    public function store() {
        return $this->belongsTo(Store::class);
    }

    public function simpleroles(){
        return Role::all()->except(2);
    }

    public function events(){
        return $this->hasMany(Event::class,'creator_id');
    }

    public function contact() {
        return $this->hasOne(Contact::class);
    }


    public function announcements() {
        return $this->belongsToMany(Announcement::class);
    }


    public function routeNotificationForVonage($notification)
    {
        return $this->mobile;

    }

//    public function getNameAttribute(){
//        return $this->fname ." ". $this->lname;
//    }


}
