<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Arr;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        $role = Arr::except(func_get_args(), [0,1]);


        if (!user()) {
            return redirect('login');
        }


        if (user()->hasAnyRole($role)){
            return $next($request);
        }
        return redirect(backpack_url(''));
    }
}
