<?php
namespace App\Http\Middleware;
use Auth;
use Closure;
use Illuminate\Support\Arr;

class PermissionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $permission)
    {

        $permissions = Arr::except(func_get_args(), [0,1]);

        foreach ($permissions as $permission){
            if (! user()->can($permission)) {
                \Alert::error(__("app.not_allowed"))->flash();
                return redirect(backpack_url(''));
            }
        }

        return $next($request);
    }
}